<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Item extends Model 
{

    protected $table = 'items';
    public $timestamps = true;
    protected $fillable = array('name', 'code', 'user_id', 'unit', 'description');

    public function user()
    {
        return $this->belongsTo('App\User');
    }

    public function in_requests()
    {
        return $this->morphedByMany('App\Models\InRequest', 'itemable');
    }

    public function serial_numbers()
    {
        return $this->hasMany('App\Models\Quantity');
    }

    public function meters()
    {
        return $this->hasMany('App\Models\Meter');
    }

    public function out_requests()
    {
        return $this->morphedByMany('App\Models\OutRequest', 'itemable');
    }

}